#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <winsock2.h>
#include <sys/types.h>
#define BUFFER_LEN 256

/* run this program using the console pauser or add your own getch, system("pause") or input loop */
/*       os argumentos na funo main() servem para o que  inserido no terminal
         ser passado para o progama em *agrv[1-n] e argc  n    */
int server(int argc, char *argv[]);    
void error(char *msg);

int main(int argc, char *argv[]) {

	return 0;
}

int server(int argc, char *argv[]) {
    int sockfd, newsockfd, portno, clilen;
    char buffer[BUFFER_LEN];
    struct sockaddr_in serv_addr, cli_addr;
	int n;
	
	/*
	** O programa precisa de 1 argumento na consola:
	**	que  o numero da porta em que o server 
	**  vai estar a ouvir
	*/
	if (argc < 2) {
		fprintf(stderr,"ERRO, Nenhuma porta especificada\n");
		exit(1);
	}
	
	/*
	** Criao do socket IP de tipo Stream 
	** https://www.gnu.org/software/libc/manual/html_node/Communication-Styles.html#Communication-Styles
	*/
	sockfd = socket(AF_INET, SOCK_STREAM, 0);
	/*
	** Verifica se a funo socket foi executada com successo 
	** -> Se No: chama a funo error() para excrever no terminal
	*/	
	if (sockfd < 0) 
		error("ERROR opening socket");
	
	//enche o struct serv_addr com o valor 0 
	memset((char *) &serv_addr, '\0', sizeof(serv_addr));
	
	//numero da porta = 1 argumento
	portno = atoi(argv[1]);
	
	//OOP Setup das propriedades
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = INADDR_ANY;
	serv_addr.sin_port = htons(portno);
	
	//ligar o socket a porta (isto ir pedir ao windows para
	//para adicionar uma excepo ao firewall)
	if (bind(sockfd, (struct sockaddr *) &serv_addr,
	      sizeof(serv_addr)) < 0) 
	      error("ERROR on binding");
	//modo de escuta
	listen(sockfd,5);
	
	//tamanho do struct do client
	clilen = sizeof(cli_addr);
	
	//cria um struct com a coneo
	newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen);
	
	//verifica se o anterior teve sucesso
	if (newsockfd < 0) 
	  error("ERROR on accept");
	
	//zera o buffer
	memset(buffer,'\0',256);
	
	//n  a mensagem enviada
	n = read(newsockfd,buffer,255);
	
	//se houve um erro na instruo anteriror
	if (n < 0) error("Erro na recepo.");
	
	printf("Recebi a mensagem: %s\n",buffer);
	
	//resposta ao envio
	n = write(newsockfd,"Recebi a tua mensagem.",18);
	
	//se houve um erro conseguiu escrever
	if (n < 0) error("Falha no envio.");
	
	return 0; 
}

void error(char *msg)
{
    perror(msg);
    exit(0);
}
